# Intuition
<!-- Describe your first thoughts on how to solve this problem. -->
Dynamic way to solve.

# Approach
<!-- Describe your approach to solving the problem. -->
- Created an array : record[i] will store number of ways to sum up to 'i'
- From start find ways to each numbers from 0 to target
- - now search in nums array
- - if number is less than current target(i) then only it will be used to sum up 
- - - add the number of ways of other complementary target

---
Have a look at code for better understanding, if still have any confusion then please let me known at comments.
Keep solving...:)

# Complexity
- Time complexity : $$O(target * |nums|)$$
<!-- Add your time complexity here, e.g. $$O(n)$$ -->

- Space complexity :  $$O(target)$$
<!-- Add your space complexity here, e.g. $$O(n)$$ -->

# Code
```
class Solution {
    public int combinationSum4(int[] nums, int target) {
         int [] record = new int[target+1];     // record[i] will store number of ways to sum up to 'i'
        record[0] = 1;                         // 'cause there is only 1 way to reach sum 0

        for( int i = 0; i <= target; i++){     // from start find ways to each numbers from 0 to target
            for( int n : nums){                // now search in nums array
                if( n <= i){                      // if number is less than current target(i) then only it will be used to sum up 
                    record[i] += record[i-n];     // add the number of ways of other complementary
                }
            }
        }
        //System.out.println( Arrays.toString(record));
        return record[target];
    }
}
```